/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.AEntityCrafter;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBrewer;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityFurnace;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketCrafterFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public final class PartInteractable
extends APart {
    public final AEntityCrafter crafter;
    public final EntityInventoryContainer inventory;
    public final EntityFluidTank tank;
    public String jerrycanFluid;
    public boolean batteryCharged;
    public PartInteractable linkedPart;
    public EntityVehicleF_Physics linkedVehicle;
    public static final String JERRYCAN_FLUID_NAME = "jerrycanFluid";
    public static final String BATTERY_CHARGED_NAME = "batteryCharged";

    public PartInteractable(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartInteractable item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        switch (((JSONPart)this.definition).interactable.interactionType) {
            case FURNACE: {
                this.crafter = new EntityFurnace(this.world, data != null ? data.getData("crafter") : null, ((JSONPart)this.definition).interactable);
                this.inventory = this.crafter;
                this.tank = null;
                this.world.addEntity(this.crafter);
                break;
            }
            case BREWER: {
                this.crafter = new EntityBrewer(this.world, data != null ? data.getData("crafter") : null, ((JSONPart)this.definition).interactable);
                this.inventory = this.crafter;
                this.tank = null;
                this.world.addEntity(this.crafter);
                break;
            }
            case CRATE: {
                this.crafter = null;
                this.inventory = new EntityInventoryContainer(this.world, data != null ? data.getData("inventory") : null, (int)(((JSONPart)this.definition).interactable.inventoryUnits * 9.0f), ((JSONPart)this.definition).interactable.inventoryStackSize > 0 ? ((JSONPart)this.definition).interactable.inventoryStackSize : 64);
                this.tank = null;
                this.world.addEntity(this.inventory);
                if (data != null || ((JSONPart)this.definition).interactable.defaultInventory == null) break;
                for (String itemText : ((JSONPart)this.definition).interactable.defaultInventory) {
                    PackMaterialComponent component = new PackMaterialComponent(itemText);
                    if (!component.possibleItems.isEmpty()) {
                        this.inventory.addStack(component.possibleItems.get(0));
                        continue;
                    }
                    InterfaceManager.coreInterface.logError("Tried to get a default item named " + itemText + " on " + this + " but couldn't as the item doesn't exist!  Report this to the pack author!");
                }
                break;
            }
            case BARREL: {
                this.crafter = null;
                this.inventory = null;
                this.tank = new EntityFluidTank(this.world, data != null ? data.getData("tank") : null, (int)(((JSONPart)this.definition).interactable.inventoryUnits * 10000.0f));
                this.world.addEntity(this.tank);
                break;
            }
            case JERRYCAN: {
                this.jerrycanFluid = data != null ? data.getString(JERRYCAN_FLUID_NAME) : "";
                this.crafter = null;
                this.inventory = null;
                this.tank = null;
                break;
            }
            case BATTERY: {
                this.batteryCharged = data != null ? data.getBoolean(BATTERY_CHARGED_NAME) : false;
            }
            default: {
                this.crafter = null;
                this.inventory = null;
                this.tank = null;
            }
        }
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (this.vehicleOn == null || !this.vehicleOn.lockedVar.isActive) {
            switch (((JSONPart)this.definition).interactable.interactionType) {
                case FURNACE: 
                case BREWER: 
                case CRATE: 
                case CRAFTING_BENCH: {
                    player.sendPacket(new PacketPartInteractable(this, player));
                    break;
                }
                case CRAFTING_TABLE: {
                    player.openCraftingGUI();
                    this.playersInteracting.add(player);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, true));
                    break;
                }
                case JERRYCAN: 
                case BATTERY: {
                    this.remove();
                    this.world.spawnItemStack(this.getStack(), this.position, null);
                    break;
                }
                case BARREL: {
                    player.getHeldStack().interactWith(this.tank, player);
                }
            }
        } else {
            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
        }
        return true;
    }

    @Override
    public LanguageSystem.LanguageEntry checkForRemoval(IWrapperPlayer player) {
        if (!((JSONPart)this.definition).generic.canBeRemovedByHand && this.inventory != null && this.getMass() > (double)((JSONPart)this.definition).generic.mass) {
            return LanguageSystem.INTERACT_PARTREMOVE_INVENTORY;
        }
        return super.checkForRemoval(player);
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater && damage.amount > 25.0) {
            this.destroy(damage.box);
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.inventory != null) {
            this.inventory.remove();
        }
        if (this.tank != null) {
            this.tank.remove();
        }
    }

    @Override
    public void destroy(BoundingBox box) {
        double explosivePower = this.getExplosiveContribution();
        if (explosivePower > 0.0 && this.isValid) {
            super.destroy(box);
            if (!((JSONPart)this.definition).interactable.hasBlowoutPanels) {
                this.masterEntity.destroy(this.masterEntity.boundingBox);
                if (((Boolean)ConfigSystem.settings.damage.vehicleExplosions.value).booleanValue()) {
                    this.world.spawnExplosion(this.position, explosivePower, (Boolean)ConfigSystem.settings.damage.vehicleBlockBreaking.value, (Boolean)ConfigSystem.settings.damage.vehicleBlockBreaking.value);
                } else {
                    this.world.spawnExplosion(this.position, 0.0, false, false);
                }
            }
        } else {
            super.destroy(box);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.crafter != null) {
            this.crafter.update();
            if (this.crafter.ticksLeftToCraft > 0) {
                if (!this.world.isClient() && this.crafter.ticksLeftOfFuel == 0) {
                    this.addCrafterFuel();
                }
                if (this.vehicleOn != null) {
                    this.vehicleOn.electricUsage += this.crafter.powerToDrawPerTick;
                }
            }
        }
        if (!this.world.isClient()) {
            EntityFluidTank linkedTank = null;
            LanguageSystem.LanguageEntry linkedMessage = null;
            if (this.linkedVehicle != null) {
                if (!this.linkedVehicle.isValid || !this.linkedVehicle.position.isDistanceToCloserThan(this.position, 16.0)) {
                    linkedMessage = LanguageSystem.INTERACT_FUELHOSE_LINKDROPPED;
                } else {
                    linkedTank = this.linkedVehicle.fuelTank;
                }
            } else if (this.linkedPart != null) {
                if (!this.linkedPart.isValid || !this.linkedPart.position.isDistanceToCloserThan(this.position, 16.0)) {
                    linkedMessage = LanguageSystem.INTERACT_FUELHOSE_LINKDROPPED;
                } else {
                    linkedTank = this.linkedPart.tank;
                }
            }
            if (linkedTank != null) {
                String fluidToTransfer = this.tank.getFluid();
                String fluidModToTransfer = this.tank.getFluidMod();
                if (!fluidToTransfer.isEmpty()) {
                    double amountToTransfer = linkedTank.fill(fluidToTransfer, fluidModToTransfer, 10.0, false);
                    if (amountToTransfer > 0.0) {
                        if ((amountToTransfer = this.tank.drain(fluidToTransfer, fluidModToTransfer, amountToTransfer, true)) > 0.0) {
                            linkedTank.fill(fluidToTransfer, fluidModToTransfer, amountToTransfer, true);
                        } else {
                            linkedMessage = LanguageSystem.INTERACT_FUELHOSE_TANKEMPTY;
                        }
                    } else {
                        linkedMessage = LanguageSystem.INTERACT_FUELHOSE_TANKFULL;
                    }
                } else {
                    linkedMessage = LanguageSystem.INTERACT_FUELHOSE_TANKEMPTY;
                }
            }
            if (linkedMessage != null) {
                this.linkedVehicle = null;
                this.linkedPart = null;
                for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                    player.sendPacket(new PacketPlayerChatMessage(player, linkedMessage, new Object[0]));
                }
            }
        }
    }

    private void addCrafterFuel() {
        switch (this.crafter.definition.crafterType) {
            case STANDARD: {
                IWrapperItemStack currentFuel = this.crafter.getStack(0);
                if (!currentFuel.isEmpty() && currentFuel.getMaxSize() >= currentFuel.getSize()) break;
                for (APart part : this.linkedParts) {
                    if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || ((JSONPart)part.definition).interactable.interactionType != JSONPart.InteractableComponentType.CRATE) continue;
                    PartInteractable crate = (PartInteractable)part;
                    for (int i = 0; i < crate.inventory.getSize(); ++i) {
                        IWrapperItemStack stack = crate.inventory.getStack(i);
                        if (this.crafter.getFuelTime(stack) == 0 || !currentFuel.isEmpty() && !stack.isCompleteMatch(currentFuel)) continue;
                        this.crafter.ticksLeftOfFuel = this.crafter.ticksFuelProvides = stack.getFurnaceFuelValue();
                        crate.inventory.removeFromSlot(i, 1);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketCrafterFuelAdd(this.crafter));
                        return;
                    }
                }
                break;
            }
            case FUEL: {
                for (APart part : this.linkedParts) {
                    if (!(part instanceof PartInteractable) || !part.isActive || !((JSONPart)part.definition).interactable.feedsVehicles || ((JSONPart)part.definition).interactable.interactionType != JSONPart.InteractableComponentType.BARREL) continue;
                    PartInteractable barrel = (PartInteractable)part;
                    if (!(barrel.tank.getFluidLevel() > 0.0) || !ConfigSystem.settings.fuel.fuels.get("furnace").containsKey(barrel.tank.getFluid())) continue;
                    this.crafter.ticksLeftOfFuel = this.crafter.ticksFuelProvides = (int)(ConfigSystem.settings.fuel.fuels.get("furnace").get(barrel.tank.getFluid()) * 20.0 * (double)this.crafter.definition.crafterEfficiency);
                    barrel.tank.drain(1.0, true);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketCrafterFuelAdd(this.crafter));
                }
                break;
            }
            case ELECTRIC: {
                this.crafter.powerToDrawPerTick = 0.0;
                if (this.vehicleOn == null || !(this.vehicleOn.electricPower > 1.0)) break;
                int ticksToDrawPower = (int)(500.0f * this.crafter.definition.crafterEfficiency);
                this.crafter.powerToDrawPerTick = 1.0 / (double)ticksToDrawPower;
                this.crafter.ticksLeftOfFuel = this.crafter.ticksFuelProvides = ticksToDrawPower;
                InterfaceManager.packetInterface.sendToAllClients(new PacketCrafterFuelAdd(this.crafter));
            }
        }
    }

    @Override
    public double getMass() {
        double currentMass = super.getMass();
        if (this.inventory != null) {
            currentMass += this.inventory.getMass();
        } else if (this.tank != null) {
            currentMass += this.tank.getMass();
        }
        return currentMass;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "interactable_count_stacks": {
                return new ComputedVariable(this, variable, partialTicks -> this.inventory != null ? (double)this.inventory.cachedStackCount : 0.0, false);
            }
            case "interactable_count_items": {
                return new ComputedVariable(this, variable, partialTicks -> this.inventory != null ? (double)this.inventory.cachedItemCount : 0.0, false);
            }
            case "interactable_percent": {
                return new ComputedVariable(this, variable, partialTicks -> this.inventory != null ? (double)this.inventory.cachedStackCount / (double)this.inventory.getSize() : (this.tank != null ? this.tank.getFluidLevel() / (double)this.tank.getMaxLevel() : 0.0), false);
            }
            case "interactable_capacity": {
                return new ComputedVariable(this, variable, partialTicks -> this.inventory != null ? (double)this.inventory.getSize() : (double)(this.tank != null ? this.tank.getMaxLevel() / 1000 : 0), false);
            }
            case "interactable_active": {
                return new ComputedVariable(this, variable, partialTicks -> !this.playersInteracting.isEmpty() ? 1.0 : 0.0, false);
            }
            case "interactable_fuel": {
                return new ComputedVariable(this, variable, partialTicks -> this.crafter != null ? (double)this.crafter.ticksLeftOfFuel : 0.0, false);
            }
            case "interactable_remaining": {
                return new ComputedVariable(this, variable, partialTicks -> this.crafter != null ? (double)this.crafter.ticksLeftToCraft : 0.0, false);
            }
        }
        if (variable.startsWith("interactable_fluid_")) {
            String fluidName = variable.substring(variable.lastIndexOf("_") + 1);
            return new ComputedVariable(this, variable, partialTicks -> this.tank.getFluid().equals(fluidName) ? 1.0 : 0.0, false);
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    public double getExplosiveContribution() {
        if (this.inventory != null) {
            return this.inventory.getExplosiveness();
        }
        if (this.tank != null) {
            return this.tank.getExplosiveness();
        }
        return 0.0;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.crafter != null) {
            data.setData("crafter", this.crafter.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        } else if (this.inventory != null) {
            data.setData("inventory", this.inventory.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        } else if (this.tank != null) {
            data.setData("tank", this.tank.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        } else if (((JSONPart)this.definition).interactable.interactionType == JSONPart.InteractableComponentType.JERRYCAN) {
            data.setString(JERRYCAN_FLUID_NAME, this.jerrycanFluid);
        } else if (((JSONPart)this.definition).interactable.interactionType == JSONPart.InteractableComponentType.BATTERY) {
            data.setBoolean(BATTERY_CHARGED_NAME, this.batteryCharged);
        }
        return data;
    }
}

